<?php $nonce = wp_create_nonce( 'quttera' ); ?>

<script type="text/javascript">

    jQuery(document).ready(function($) {
        $.ajaxSetup({
            type: 'POST',
            url: ajaxurl, /* predefined WP value */
            complete: function(xhr,status) {
                if ( status != 'success' ) {
                    console.log("Failed to communicate with WP");
                }
            }
        });

        $('#run-scanner').click( function() {
            var url             = $('#url_name').val();
            var qtr_srv_name    = $('#qtr_srv_name').val();
                
            $.ajaxSetup({
                type: 'POST',
                url: ajaxurl, /* predefined WP value */
                complete: function(xhr,status) {
                    if ( status != 'success' ) {
                        //alert("Failed to communicate with WP");
                    }
                }
            });

            QtrRunExternalScan(url,qtr_srv_name);
            $('#run-scanner').hide();
            return false;
        });
    }); 


    /*
     * URL validation procedure
     */
    function QtrValidateURL(textval) {
         var urlregex = new RegExp(
            "^(http|https|ftp)\://([a-zA-Z0-9\.\-]+(\:[a-zA-Z0-9\.&amp;%\$\-]+)*@)*((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])|([a-zA-Z0-9\-]+\.)*[a-zA-Z0-9\-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2,12}))(\:[0-9]+)*(/($|[a-zA-Z0-9\.\,\?\'\\\+&amp;%\$#\=~_\-]+))*$");
         return urlregex.test(textval);
    }

    /*
     * Domain validation procedure
     */
    function QtrValidateDomain(domain) { 
        //var re = new RegExp(/^[a-zA-Z0-9][a-zA-Z0-9-_]{0,61}[a-zA-Z0-9]{0,1}\.([a-zA-Z]{1,6}|[a-zA-Z0-9-]{1,30}\.[a-zA-Z]{2,10})$/); 
        var d = domain.trim();
        var re = new RegExp(/^(www\.)?([a-zA-Z0-9][a-zA-Z0-9-_]{0,45}[a-zA-Z0-9]\.)+[a-zA-Z]{2,10}$/);
        return d.match(re);
    }   


    function QtrRunExternalScan (this_url,qtr_url,level) 
    {
        if( !QtrValidateDomain(this_url) ){
	        QtrHideInvestigationElements();
            var curr_time = new Date().getTime();
            QtrShowInvestigationStatus( {    "state" : "Provided name of this web-site is invalid", 
                                            "age"   : curr_time,
                                            "url"   : "<invalid>"
                                       });
	        return;
	    }

        if( !QtrValidateURL(qtr_url) ){
    	    QtrHideInvestigationElements();
            var curr_time = new Date().getTime();
            QtrShowInvestigationStatus({ "state" : "Provided name of Qutter web malware scanner is invalid", 
                                        "age"   : curr_time,
                                        "url"   : "<invalid>" });
    	    return;
	    }

        if( !level )
        {
            QtrHideInvestigationElements();
            var curr_time = new Date().getTime();
            QtrShowInvestigationStatus( {    "state" : "starting", 
                                            "age"   : curr_time,
                                            "url"   : this_url });
        }

        jQuery.ajax({
            data: {
                action: 'scanner-run_scan',
                _this: this_url,
                _wpnonce: '<?php echo $nonce; ?>',
                _qtr_url: qtr_url
            }, 
            success: function(r) {
                var res = jQuery.parseJSON(r);
                var state = res.content.state.toLowerCase();
                
                if ( state == 'new' )
                {
                    QtrShowInvestigationStatus({ "state" : "Waiting for free web malware scanner slot.",
                                                "age"   : res.content.age,
                                                "url"   : res.content.url,
                                                "priority" : res.content.priority });

                    QtrRunExternalScan(this_url,qtr_url,1); //recursive call
                }
                else if( state == 'download')
                {
                    QtrShowInvestigationStatus({ "state" : "Website content is being downloaded for investigation.", 
                                                "age"   : res.content.age,
                                                "url"   : res.content.url,
                                                "priority" : res.content.priority,
                                                "processed_files": res.content.processed_files  });

                    QtrRunExternalScan(this_url,qtr_url,1); //recursive call
                }
                else if( state =='downloaded' )
                {
                    QtrShowInvestigationStatus({ "state" : "Website content has been downloaded and is waiting for scanner.", 
                                                "age"   : res.content.age,
                                                "url"   : res.content.url,
                                                "priority" : res.content.priority });

                    QtrRunExternalScan(this_url,qtr_url,1); //recursive call
                }
                else if( state =='scan' || state =='scanned' )
                {
                    QtrShowInvestigationStatus({ "state" : "website content is being scanned", 
                                                "age"   : res.content.age,
                                                "url"   : res.content.url,
                                                "priority" : res.content.priority,
                                                "processed_files": res.content.processed_files });

                    QtrRunExternalScan(this_url,qtr_url,1); //recursive call
                }
                else if( state == 'clean' )
                {
                    QtrShowInvestigationReport(res.content);
                }
                else if( state=='potentially suspicious' || state=='potentially unsafe' )
                {
                    QtrShowInvestigationReport(res.content);
                }
                else if (state=='suspicious' || state=='unsafe')
                {
                    QtrShowInvestigationReport(res.content);                
                }
                else if (state=='malicious')
                {
                    QtrShowInvestigationReport(res.content);                
                }
                else
                {
                    QtrShowInvestigationError(res.content);
                }                
            }//end of success function
        });
    };


    function QtrShowInvestigationError ( status )
    {
        var urlDate     = new Date();
        var currentdate = urlDate.toLocaleString();

        jQuery('#investigation_error').empty();
            var str =   "<b>State</b>: <font color='red'>"   + status.state  + "</font></br>" +
                        "<b>Time</b>: "    + currentdate   + "</br>" +
                        "<b>URL</b>: "     + status.url;
        //alert("Status: " + str );
        QtrHideInvestigationElements();
        jQuery('#investigation_error').append("<p>" + str + "</p>");
        jQuery('#investigation_error').show();
        jQuery('#run-scanner').show();
    }
   
    /*
     * status comprised from fields:
     *      url  
     *      priority
     *      state  
     *      age   
     *      processed_files
     */  
    function QtrShowInvestigationStatus ( status )
    {
        QtrHideInvestigationElements();
        var urlDate     = new Date();
        var currentdate = urlDate.toLocaleString();

        jQuery('#investigation_progress').empty();
        var str = "<b>State</b>: <b><font color='green'>" + status.state  + "</font></b></br>" +
                  "<b>Time</b>: "  + currentdate   + "</br>" +
                  "<b>URL</b>: "   + status.url    + "</br>";

        if( status.priority )
        {
            str += "<b>Investigation priority</b>: " + status.priority + "</br>";
        }

        if( status.processed_files )
        {
            str += "<b>Processed files</b>: " + status.processed_files + "</br>";
        }
        
        jQuery('#investigation_progress').append("<p>" + str + "</p>");
        jQuery('#investigation_progress').show();
    };
   
 
    function QtrShowInvestigationReport ( scan_report )
    {
        QtrHideInvestigationElements();
        jQuery('#investigation_result').empty();
        jQuery('#investigation_result').append('<H2>Website Malware Investigation Report</H2><hr>');
        jQuery('#investigation_result').append('<a href="http://quttera.com/article/about-quttera-malware-scan-report" target="_blank">Understanding security reports</a>');
                
        var clean_files             = 0;
        var pot_suspicious_files    = 0;
        var suspicious_files        = 0;
        var malicious_files         = 0;
        
        for( var i = 0; i < scan_report.report.length; i ++ )
        {
            var threat = scan_report.report[i].threat.toLowerCase();
            if( threat == "malicious" ){
                malicious_files         += 1;
            }else if( threat == "suspicious" ){
                suspicious_files        +=1;
            }else if( threat == "potentially suspicious"){
                pot_suspicious_files    += 1;
            }else{
                clean_files             += 1;
            }
        }

        var summary =   "<table>" +
                        "<tr><td align='left'><b>Server IP:</b></td>" +
                             "<td align='left'><b>" + scan_report.ipaddr + "</b></td></tr>" +

                        "<tr><td align='left'><b>Location:</b></td>" +
                             "<td align='left'><b>" + scan_report.country + "</b></td></tr>" +

                        "<tr><td align='left'><b>Web Server:</b></td>" +
                             "<td align='left'><b>" + scan_report.http_server + "</b></td></tr>" +

                        "<tr><td align='left'><font color='green'><b>Clean files: </b></font></td>"+
                            "<td align='left'><font color='green'><b>"  + clean_files + "</b></font></td></tr>" +

                        "<tr><td align='left'><font color='orange'><b>Potentially Suspicious files: </b></font></td>"+
                            "<td align='left'><font color='orange'><b>" + pot_suspicious_files + "</b></font></td></tr>" +

                        "<tr><td align='left'><font color='red'><b>Suspicious files: </b></font></td>"+
                            "<td align='left'><font color='red'><b>" + suspicious_files + "</b></font></td></tr>" +

                        "<tr><td align='left'><font color='#780000'><b>Malicious files: </b></font></td>" +
                            "<td align='left'><font color='#780000'><b>"    + malicious_files + "</b></font></td></tr>";


        if(  scan_report.is_blacklisted )
        {
            if(  scan_report.is_blacklisted &&  scan_report.is_blacklisted.toLowerCase() == "no" )
            {
                summary +=  "<tr><td align='left'><font color='green'><b>Blacklisted: </b></font></td>"+
                                    "<td align='left'><font color='green'><b>"  + scan_report.is_blacklisted + "</b></font></td></tr>";
            }
            else
            {
                summary +=  "<tr><td align='left'><font color='red'><b>Blacklisted: </b></font></td>"+
                                    "<td align='left'><font color='red'><b>"  + scan_report.is_blacklisted + "</b></font></td></tr>";
            }
        }

        summary +=      "<tr><td align='left'><b>External links:</b></td>" +
                             "<td align='left'><b>" + scan_report.links_count + "</b></td></tr>" +

                        "<tr><td align='left'><b>Detected iframes:</b></td>" +
                             "<td align='left'><b>" + scan_report.iframes_count + "</b></td></tr>" +

                        "<tr><td align='left'><b>External domains:</b></td>" +
                             "<td align='left'><b>" + scan_report.domains_count + "</b></td></tr>" +
 
                        "</table>" + 
                        "<hr/>";

        jQuery('#investigation_result').append(summary);
        
        var scanner_server = document.getElementById('qtr_srv_name').value;
        var domain_name    = document.getElementById('url_name').value;
        //var full_url       = scanner_server + "/detailed_report/" + domain_name;
        var full_url       = "https://quttera.com/detailed_report/" + domain_name;
        jQuery('#investigation_result').append("<form method='get' action='" + full_url + "' target='new'>" +
                "<input type='submit' class='button-primary' value='Full Investigation Report' style='font-weight: bold;'/></form>");
        
        jQuery('#investigation_report_info').show();
        jQuery('#run-scanner').show();
        jQuery('#investigation_result').show();       
    };
    
    
    function QtrHideInvestigationElements( )
    {
        jQuery('#investigation_result').hide();
        jQuery('#investigation_error').hide();
        jQuery('#investigation_progress').hide();    
        jQuery('#quttera_detected_malicious_content').hide();    
    }

</script>

